/*
 * Decompiled with CFR 0.152.
 */
package dev.kosmx.playerAnim.core.data.opennbs.format;

import java.util.ArrayList;
import javax.annotation.Nullable;

public class Layer {
    public String name;
    public byte lock;
    public byte volume = (byte)100;
    public byte stereo = (byte)100;
    private int lastUsedTickPos = 0;
    public final ArrayList<Note> notes = new ArrayList();

    public boolean getLock() {
        return this.lock != 0;
    }

    public void setLock(boolean newValue) {
        this.lock = (byte)(newValue ? 1 : 0);
    }

    public int findAtTick(int tick) {
        int i = -1;
        if (this.notes.size() > this.lastUsedTickPos + 1 && this.notes.get((int)(this.lastUsedTickPos + 1)).tick <= tick) {
            i = this.lastUsedTickPos;
        }
        while (this.notes.size() > i + 1 && this.notes.get((int)(i + 1)).tick <= tick) {
            ++i;
        }
        this.lastUsedTickPos = i;
        return i;
    }

    @Nullable
    public Note addNote(int tick) {
        if (this.getLock()) {
            return null;
        }
        int i = this.findAtTick(tick);
        if (i > 0 && this.notes.get((int)i).tick == tick) {
            return null;
        }
        Note note = new Note(tick);
        this.notes.add(i + 1, note);
        return note;
    }

    public ArrayList<Note> getNotesFrom(int fromTick, int toTick) {
        ArrayList<Note> returnNotes = new ArrayList<Note>();
        int posAtBegin = this.findAtTick(fromTick);
        if (this.notes.size() >= posAtBegin) {
            ++posAtBegin;
        }
        int posAtEnd = this.findAtTick(toTick);
        if (this.notes.size() >= posAtEnd) {
            ++posAtEnd;
        }
        if (posAtBegin < 0) {
            posAtBegin = 0;
        }
        while (posAtBegin < posAtEnd) {
            returnNotes.add(this.notes.get(posAtBegin));
            ++posAtBegin;
        }
        return returnNotes;
    }

    public ArrayList<Note> getNotesFrom(int toTick) {
        return this.getNotesFrom(this.lastUsedTickPos, toTick);
    }

    public class Note {
        public byte instrument;
        public byte key;
        public byte velocity = (byte)100;
        public byte panning = (byte)100;
        public short pitch = 0;
        public final int tick;

        public Note(int tick) {
            this.tick = tick;
        }

        public float getPitch() {
            return (float)Math.pow(2.0, (double)(this.key + this.pitch / 100 - 45) / 12.0);
        }

        public float getVolume() {
            return (float)this.velocity / 10000.0f * (float)Layer.this.volume;
        }
    }
}

